function [ params ] = analyze_subject_edge_residuals_glmnet_params()

% Parameters for analyze_subject_edge_residuals
%
% RETURNS:
% params        Optional parameters as a struct, with fields:
%
%       p_threshold         p- and q-value threshold for the reference model; 
%                           default is 0.05    
%       do_fdr              Whether to correct for multiple comparisons
%                           using FDR; default is true
%       abs_resid           Whether to use the absolute value of the
%                           residuals; default is true
%       alphas              Alpha values to use for the glmnet prediction;
%                           determines the beta penalty method, on a
%                           continuum from ridge regression (alpha=0) to
%                           lasso (alpha=1); default is 0:0.25:1. See 
%                           glmnet for details
%       nfolds              Number of folds for cross-validation; default
%                           is 50. See cvglmnet for details
%       foldid              Prespecified folds; default is []. See cvglmnet
%                           for details
%
%       [glmnetSet parameters]
%
% 
%
% results       A struct containing the output of the analysis...
%
% AUTHOR: Andrew Reid, MNI, 2011

params=glmnetSet;
params.p_threshold = 0.05;
params.do_fdr = true;
params.abs_resid = true;
params.alphas=0:0.25:1;
params.nfolds=50;
params.foldid=[];
params.verbose=true;
params.niters=50;
params.resid_type='perp';


