function [ results ] = analyze_adni_weighted_pcorr_across_exp ( regional_thickness, groups, group_list, show_plots, params, keep_boots );

% Computes weighted efficiency values using analyze_adni_weighted, across a
% range of exponents defined by params.exp_min, params.exp_max, and
% params.exp_step. See Schwarz & McGonigle, Neuroimage, 2011.
%
% Optionally shows line graphs
%

if (nargin < 6)
    keep_boots = false;
end

colours = ['r' 'g' 'b' 'c' 'm' 'y']; 

exp_min=params.exp_min;
exp_max=params.exp_max;
exp_step=params.exp_step;

exponents = exp_min : exp_step : exp_max;
L = length(exponents);
labels=cell(L,1);

i = 1;
for ex = exp_min : exp_step : exp_max;
   
    fprintf('\n');
    fprintf(strcat('Exponent: ', num2str(ex)));
    params.scale_exp = ex;
    % This string crap is ridiculous, Matlab
    label = strcat('exp', num2str(i));
    results.(label) = analyze_adni_weighted_pcorr(regional_thickness, groups, group_list, false, params, keep_boots);
    labels(i) = {label};
    i = i + 1;
    
end



if show_plots
    
    N = params.boot_m;
    
    % Global - sparsity
    for g = 1 : length(group_list)
        group = cell2mat(group_list(g));
        
        results.(group).sparsity = zeros(L,1);
        results.(group).e_global.mean = zeros(L,1);
        results.(group).e_global.std = zeros(L,1);
        
         
        % list of stats
        for i = 1 : L
            
            label = char(labels(i));
            wtf = results.(label).(group).e_global(:);
            results.(group).e_global.mean(i) = mean(wtf);
            results.(group).e_global.std(i) = std(results.(label).(group).e_global(:));
            results.(group).sparsity(i) = mean(results.(label).(group).sparsity(:));
%             K = round(results.(group).sparsity(i) * N);
%             ws_result = evaluate_watts_strogatz_model(N,K,10,20);
%             WL = length(ws_result.mean_e_global);
%             results.(group).e_global.regular(i) = ws_result.mean_e_global(1);
%             results.(group).e_global.random(i) = ws_result.mean_e_global(WL);
%             results.(group).e_local.regular(i) = ws_result.mean_e_local(1);
%             results.(group).e_local.random(i) = ws_result.mean_e_local(WL);
            
        end
        
        % Global
        if g < length(colours)
           colour = colours(g);
        else
           colour = 'b'; % temp; generate random here
        end
        if g == 1
           figure;
           errorbar(results.(group).sparsity, results.(group).e_global.mean, results.(group).e_global.std, colour);
           title('Global Efficiency (across exponents)', 'FontWeight', 'bold');
           xlabel('Sparsity');
           hold on; 
        else
           errorbar(results.(group).sparsity, results.(group).e_global.mean, results.(group).e_global.std, colour);
        end
        
    end
    
    legend(group_list);
    hold off;
    
    % Global - exponents
    for g = 1 : length(group_list)
        group = cell2mat(group_list(g));
        
        if g < length(colours)
           colour = colours(g);
        else
           colour = 'b'; % temp; generate random here
        end
        if g == 1
           figure;
           errorbar(exponents, results.(group).e_global.mean, results.(group).e_global.std, colour);
           title('Global Efficiency (across exponents)', 'FontWeight', 'bold');
           xlabel('Exponent');
           hold on; 
        else
           errorbar(exponents, results.(group).e_global.mean, results.(group).e_global.std, colour);
        end
        
    end
    
    legend(group_list);
    hold off;
    
    
    % Local - Sparsity
    for g = 1 : length(group_list)
        group = cell2mat(group_list(g));
        
        results.(group).e_local.mean = zeros(L,1);
        results.(group).e_local.std = zeros(L,1);
        
        % list of stats
        for i = 1 : L
        
            label = char(labels(i));
            results.(group).e_local.mean(i) = mean(results.(label).(group).e_local(:));
            results.(group).e_local.std(i) = std(results.(label).(group).e_local(:));
            
        end
        
        % Global
        if g < length(colours)
           colour = colours(g);
        else
           colour = 'b'; % temp; generate random here
        end
        if g == 1
           figure;
           errorbar(results.(group).sparsity, results.(group).e_local.mean, results.(group).e_local.std, colour);
           title('Local Efficiency (across exponents)', 'FontWeight', 'bold');
           xlabel('Sparsity');
           hold on; 
        else
           errorbar(results.(group).sparsity, results.(group).e_local.mean, results.(group).e_local.std, colour);
        end
        
        
    end
    
    legend(group_list);
    hold off;
    
    % Local - exponents
    for g = 1 : length(group_list)
        group = cell2mat(group_list(g));
        
        if g < length(colours)
           colour = colours(g);
        else
           colour = 'b'; % temp; generate random here
        end
        if g == 1
           figure;
           errorbar(exponents, results.(group).e_local.mean, results.(group).e_local.std, colour);
           title('Local Efficiency (across exponents)', 'FontWeight', 'bold');
           xlabel('Exponent');
           hold on; 
        else
           errorbar(exponents, results.(group).e_local.mean, results.(group).e_local.std, colour);
        end
        
        
    end
    
    legend(group_list);
    hold off;
   
    
    % Sparsity vs. exponents
    for g = 1 : length(group_list)
        group = cell2mat(group_list(g));
        
        if g < length(colours)
           colour = colours(g);
        else
           colour = 'b'; % temp; generate random here
        end
        if g == 1
           figure;
           plot(exponents, results.(group).sparsity, colour);
           title('Exponents vs. sparsity', 'FontWeight', 'bold');
           xlabel('Exponent');
           ylabel('Sparsity');
           hold on; 
        else
           plot(exponents, results.(group).sparsity, colour);
        end
        
        
    end
    
    legend(group_list);
    hold off;
    
end
