function [ results ] = analyze_adni_weighted_across_thres ( regional_thickness, groups, group_list, show_plots, params );

% Computes weighted efficiency values using analyze_adni_weighted, across a
% range of hard thresholds defined by params.thr_min, params.thres_max, and
% params.thres_step. 
%
% Optionally shows line graphs
%

colours = ['r' 'g' 'b' 'c' 'm' 'y']; 

thres_min=params.thres_min;
thres_max=params.thres_max;
thres_step=params.thres_step;

thresholds = thres_min : thres_step : thres_max;
L = length(thresholds);
labels=cell(L,1);

i = 1;
for thres = thres_min : thres_step : thres_max;
   
    fprintf('\n');
    fprintf(strcat('Threshold: ', num2str(thres)));
    params.hard_threshold = thres;
    % This string crap is ridiculous, Matlab
    label = strcat('thres', num2str(i));
    results.(label) = analyze_adni_weighted(regional_thickness, groups, group_list, false, params);
    labels(i) = {label};
    i = i + 1;
    
end



if show_plots
    
    % Global
    for g = 1 : length(group_list)
        group = cell2mat(group_list(g));
        
        sparsity = zeros(L,1);
        e_global.mean = zeros(L,1);
        e_global.std = zeros(L,1);
        
        % list of stats
        for i = 1 : L
            
            label = char(labels(i));
            wtf = results.(label).(group).e_global(:);
            e_global.mean(i) = mean(wtf);
            e_global.std(i) = std(results.(label).(group).e_global(:));
            sparsity(i) = mean(results.(label).(group).sparsity(:));
            
        end
        
        % Global
        if g < length(colours)
           colour = colours(g);
        else
           colour = 'b'; % temp; generate random here
        end
        if g == 1
           figure;
           errorbar(sparsity, e_global.mean, e_global.std, colour);
           title('Global Efficiency (across thresholds)', 'FontWeight', 'bold');
           hold on; 
        else
           %plot(results.sparsities, results.(group).mean.global_E, colour);
           errorbar(sparsity, e_global.mean, e_global.std, colour);
        end
        
        
    end
    
    legend(group_list);
    hold off;
    
    
    % Local
    for g = 1 : length(group_list)
        group = cell2mat(group_list(g));
        
        e_local.mean = zeros(L,1);
        e_local.std = zeros(L,1);
        
        % list of stats
        for i = 1 : L
        
            label = char(labels(i));
            e_local.mean(i) = mean(results.(label).(group).e_local(:));
            e_local.std(i) = std(results.(label).(group).e_local(:));
            sparsity(i) = mean(results.(label).(group).sparsity(:));
            
        end
        
        % Global
        if g < length(colours)
           colour = colours(g);
        else
           colour = 'b'; % temp; generate random here
        end
        if g == 1
           figure;
           errorbar(sparsity, e_local.mean, e_local.std, colour);
           title('Local Efficiency (across thresholds)', 'FontWeight', 'bold');
           hold on; 
        else
           %plot(results.sparsities, results.(group).mean.global_E, colour);
           errorbar(sparsity, e_local.mean, e_local.std, colour);
        end
        
        
    end
    
    legend(group_list);
    hold off;
    
end
