function [ profile] = analyze_adni_profile( regional_thickness, groups, group_list)

% Time profile for bootstrap processing at different parameter levels

profile.boot_n = [10 20 50 100 500];
profile.boot_m = [200];
%profile.sp_step = [0.05 0.01];
profile.elapsed = zeros(length(profile.boot_n),length(profile.boot_m));


for i = 1 : length(profile.boot_n)
   
    for j = 1 : length(profile.boot_m)
        
        params.sp_min = 0.05;
        params.sp_max = 0.4;
        params.sp_step = 0.01;
        params.boot_n = profile.boot_n(i);
        params.boot_m = profile.boot_m(j);
        params.int_start = 0.05;
        params.int_end = 0.4;
    
        fprintf('\nProfile iteration:\n');
        str = cell2mat(strcat({'boot_n: '},num2str(params.boot_n)));
        fprintf(str);
        fprintf('\n');
        str = cell2mat(strcat({'boot_m: '},num2str(params.boot_m)));
        fprintf(str);
        fprintf('\n');
        
        tic;
        
        profile.results(i,j) = analyze_adni_binary(regional_thickness, groups, group_list, false, params);
        
        profile.elapsed(i,j) = toc
        
    end
    
end

