function [ results ] = adni_weighted_stats( results, group_list, params );

boot_n = 20;

if nargin > 2
    boot_n = params.boot_n;
end

for g = 1 : length(group_list);
    group = cell2mat(group_list(g));
    
    % init variables
    results.(group).mean.e_global_regional = zeros(boot_n,1);
    results.(group).std.e_global_regional = zeros(boot_n,1);
    results.(group).mean.e_local_regional = zeros(boot_n,1);
    results.(group).std.e_local_regional = zeros(boot_n,1);
    
    % 1. Group mean and variance
    results.(group).mean.e_global = mean(results.(group).e_global);
    results.(group).std.e_global = std(results.(group).e_global);
    results.(group).mean.e_local = mean(results.(group).e_local);
    results.(group).std.e_local = std(results.(group).e_local);

    for i = 1 : boot_n
        results.(group).mean.e_global_regional(i) = mean(results.(group).e_global_regional(i,:));
        results.(group).std.e_global_regional(i) = std(results.(group).e_global_regional(i,:));
        results.(group).mean.e_local_regional(i) = mean(results.(group).e_local_regional(i,:));
        results.(group).std.e_local_regional(i) = std(results.(group).e_local_regional(i,:));
    end
      
end


% Return stats for a result from analyze_adni_weighted

i = 1;
for g1 = 1 : length(group_list);
    group1 = cell2mat(group_list(g1));
    for g2 = g1 + 1 : length(group_list);
        group2 = cell2mat(group_list(g2));
        if g1 < g2
            [h,p,~,stts]=ttest2(results.(group1).e_global, results.(group2).e_global);
            results.ttest.e_global.t(i)=stts.tstat;
            results.ttest.e_global.p(i)=p;
            [h,p,~,stts]=ttest2(results.(group1).e_local, results.(group2).e_local);
            results.ttest.e_local.t(i)=stts.tstat;
            results.ttest.e_local.p(i)=p;
            i = i + 1;
        end
    end
    
end

 % Bonferroni correction
 alpha = 0.05/(i - 1);
 results.ttest.e_global.sig=results.ttest.e_global.p < alpha;
 results.ttest.e_local.sig=results.ttest.e_local.p < alpha;
    