import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
from statsmodels.discrete.discrete_model import Logit
import statsmodels.tools.tools as sm_tools
from statsmodels.formula.api import logit

input_file = 'smoking_sample.csv'

# Read sample
with open(input_file, "r") as file_in:
    header = file_in.readline().rstrip('\n').lstrip('# ')
    nodes = header.split(',')
    N_nodes = len(nodes)

sample = np.loadtxt(input_file, comments='#', delimiter=',')

table = pd.DataFrame(data=sample, columns=nodes)
print(table)

x = sample[:,1:]
y = sample[:,0]

#logit_model = Logit(y,x)
logit_model = logit('L ~ Y + A + X', \
                    table )
result = logit_model.fit()
summary = result.summary2()

table = summary.tables[1]
print(table.loc['X','P>|z|'])