# Generate a sample from a Bayesian network
import numpy as np

# Given network, a Pandas table representing a Bayesian graph with
# binary variables and (conditional) probabilities, generates N_samp
# samples, returned as N_samp X N_nodes Numpy matrix
def generate_sample( network, N_samp ):

    nodes = list(network.keys())
    N_nodes = len(nodes)

    # Generate N samples
    sample = np.full((N_samp, N_nodes), False)
    for i in range(0, N_samp):

        sample_i = {}
        nodes_to_process = nodes.copy()
        nodes_processed = []

        # Sample for root nodes
        for node in nodes:
            if len(network[node]['Parents']) == 0:
                sample_i[node] = network[node]['ProbTrue'] > np.random.uniform(0,1)
                nodes_to_process.remove(node)
                nodes_processed.append(node)

        # Sample remaining nodes
        while len(nodes_to_process) > 0:
            for node in nodes_to_process:
                parents = network[node]['Parents']
                if all(item in nodes_processed for item in parents):
                    probs = network[node]['ProbTrue']
                    for parent in parents:
                        if len(probs) == 2:
                            idx = 1
                            if sample_i[parent]:
                                idx = 0
                            sample_i[node] = probs[idx] > np.random.uniform(0,1)
                        else:
                            if sample_i[parent]:
                                probs = probs[:len(probs)//2]
                            else:
                                probs = probs[len(probs)//2:]
                    nodes_to_process.remove(node)
                    nodes_processed.append(node)

        for j, node in zip(range(0,N_nodes),nodes):
            sample[i,j] = sample_i[node]

    sample = sample.astype('int')

    return sample