import numpy as np
import json

# Writes G as a JSON file with two components: node and links
def write_graph( file, G, nodes, coords='circle', \
                 width=500, height=500, \
                 pt_center = [0,0], \
                 labels=None, \
                 is_directed=False):
    
    N_nodes = G.shape[0]

    # Compute coords
    if coords == 'circle':
        coords = np.zeros((N_nodes,2))
        radius = min(width, height) / 2
        t = np.linspace(0, 2*np.pi, N_nodes, endpoint=False)
        coords[:,0] = radius * np.cos(t) + pt_center[0]
        coords[:,1] = radius * np.sin(t) + pt_center[1]
    
    elif type(coords) != np.ndarray:
        raise Exception('Invalid coords argument: '.format(coords))

    nodes_out = []
    # id, label, fx, fy, group
    for id,i in zip(nodes, range(N_nodes)):
        this_node = {}
        this_node['id'] = id
        if labels is not None:
            this_node['label'] = labels[id]
        else:
            this_node['label'] = id
        this_node['fx'] = coords[i,0]
        this_node['fy'] = coords[i,1]
        nodes_out.append(this_node)

    links_out = []
    # source, target
    if is_directed:
        for i in range(N_nodes):
            for j in range(N_nodes):
                if i != j:
                    if G[i,j]:
                        links_out.append({'source': nodes[i], 'target': nodes[j]})
    else:
        for i in range(N_nodes-1):
            for j in range(i+1, N_nodes):
                if G[i,j]:
                    links_out.append({'source': nodes[i], 'target': nodes[j]})

    G = {'nodes': nodes_out, 'links': links_out}

    with open(file, 'w') as fout:
        json.dump(G, fout)

# Convert network (a JSON-formatted dict) to a square Numpy matrix
def network_as_matrix( network ):

    nodes = list(network.keys())
    N_nodes = len(nodes)

    G = np.zeros((N_nodes, N_nodes))

    for node, i in zip(nodes, range(N_nodes)):
        # Get parents and add to matrix
        P = network[node]['Parents']
        for p in P:
            j = nodes.index(p)
            G[j,i] = 1

    return G

