# Generates a sample from a Bayesian network with binary variables
# two pf which are latent (unobserved)

import json
import numpy as np
from stat_functions import generate_sample

# Configuration
network_file = 'smoking_cancer_latent.json'
output_file = 'smoking_sample_latent.csv'
N_samp = 2000

# Load network from JSON file
with open(network_file) as file_in:
    network = json.load(file_in)

network_name = list(network.keys())[0]
network = network[network_name]
nodes = list(network.keys())
N_nodes = len(nodes)

print('Loaded {} with {} nodes.'.format(network_name, N_nodes))

# Generate N samples
sample = generate_sample(network, N_samp)

# Print sample to console
print(nodes)
print(sample)

# Marginal probabilities
sample = sample.astype('int')
print('Marginal Probabilities:')
for i, node in zip(range(0,N_nodes),nodes):
    print('P({0}): {1:0.4f}'.format(node, np.mean(sample[:,i])))

# Save sample to file
np.savetxt(output_file, sample, delimiter=',', fmt='%d', header=','.join(nodes))

print('Sample written to {}'.format(output_file))