function M = get_smoothed_image(N, fwhm)

% Creates an image with the specified smoothing; cuts out a larger image
% to avoid edge effects
% N is either an existing image or the size of a new square matrix

s = fwhm / (2 * sqrt(2 * log(2)));

if length(size(N)) > 1
    
    M = imgaussfilt(N, s, 'Padding', 'circular');
   
else

    margin = round(0.1*N);
    N2 = N+2*margin;
    M = imgaussfilt(rand(N2), s);
    M = M(margin:end-margin,margin:end-margin);
end

end

