%% Exploring the false discovery rate (FDR)

clear;

addpath('lib/brewermap/');

%% Generate & plot confidence intervals for sorted random p-values


close all;
h = figure;
h.Color = 'w';
fill_clr = [0.5 0.5 1];
bf_clr = [0.8 0.3 0.12];
fdr_clr = [0 0.5 0];
psig_clr = [115, 50, 168]/256;
mrk_size = 65;

M = [20 2000];
ymax = [0.1 0.001];

h.Position(3:4) = [600*length(M),450];

psig = sort(rand(20,1))*5e-4;

for i = 1 : length(M)
    subplot(1,length(M),i);
    
    m = M(i);
    pvals = sort(rand(1000,m),2);
    sp = std(pvals,1,1);
    mp = mean(pvals,1);

    alpha = 0.05;

    ci = [tinv(1-alpha/2,m-1) tinv(alpha/2,m-1)];
    idxr = m:-1:1;
    X = [1:m,idxr]';
    Y = [mp+ci(1).*sp,mp(idxr)+ci(2).*sp(idxr)]';

    hh = fill(X,Y,fill_clr);
    hh.FaceAlpha = 0.5;
    hh.LineStyle = 'none';

    hold on;
%     hh = plot(1:m, mp, 'o--');
%     hh.LineWidth = 2;
%     hh.Color = 'b';
    hh = scatter(1:m, mp, mrk_size); %, 'o--');
    hh.MarkerFaceColor = 'b';
    hh.MarkerEdgeAlpha = 0;

    alpha_bf = alpha/m;
    hh = plot(1:m,alpha_bf*ones(m,1));
    hh.Color = bf_clr;
    hh.LineWidth = 2;

    thres_fdr = (alpha/m)*(1:m);
    hh = plot(1:m,thres_fdr);
    hh.Color = fdr_clr;
    hh.LineWidth = 2;
    
    hh = scatter(1:20, psig, mrk_size); %, 'o--');
    hh.MarkerFaceColor = psig_clr;
    hh.MarkerEdgeAlpha = 0;
    
    xlim([1 20]);
    ylim([0 ymax(i)]);
    
    hh = xlabel('k');
    hh = ylabel('p-value');
    ax = gca;
    ax.FontSize = 18;
    
    hh = title(sprintf('$$N_v=%d$$', m), 'Interpreter','latex');
    hh.FontSize = 30;

end

saveas(h, 'fdr_fwer_comparison.svg');



