function [ sa, acc, t ] = anneal2d_scale( O, XY0, Trange, iter, v, S )
%ANNEAL2D 
%
% O         - objective function
% XY0       - starting x,y coordinate
% T_range   - range of mean T to vary from start to end
% iter      - number of iterations
% v         - 2x1 vector of x & y velocities
% S         - scale factor for T

sa=zeros(iter,2);
acc=zeros(iter,1);
t=zeros(iter,1);

thres=0.01;

N = size(O);

xi = XY0(1);
yi = XY0(2);

ti = Trange(2);
dt = (Trange(2)-Trange(1))/iter;
if rand>0.5, iix=1; else iix=-1; end
if rand>0.5, iiy=1; else iiy=-1; end

for i = 1 : iter
   
    t(i) = ti * S(xi,yi);
    
    zi = O(xi,yi);
    
    xii=xi+iix;
    if xii==0
       xii=2;
       iix=1;
    end
    if xii==N(1)+1
       xii=N(1)-2; 
       iix=-1;
    end
    
    yii=yi+iiy;
    if yii==0
       yii=2;
       iiy=1;
    end
    if yii==N(2)+1
       yii=N(2)-2; 
       iiy=-1;
    end
    
    zii = O(xii,yii);
    accept = exp( (zii-zi) / t(i) )-1;
    zii = O(xii,yi);
    acceptx = exp( (zii-zi) / t(i) )-1;
    zii = O(xi,yii);
    accepty = exp( (zii-zi) / t(i) )-1;
    
    isx = acceptx < thres;
    isy = accepty < thres;
    acc(i) = min([accept, acceptx, accepty]);

    if acc(i) < thres
       if isx && v(1) >= rand         % Velocity
          xi   = xii;
       end
       if isy && v(2) >= rand         % Velocity
          yi   = yii;
       end
       if accepty > thres
           iiy=-iiy;
       end
       if acceptx > thres
           iix=-iix;
       end
    else
       iix=-iix;
       iiy=-iiy;
    end

    sa(i,1) = xi;
    sa(i,2) = yi;
    
    ti = ti - dt;
    
end


end

