function [ sa, acc, t ] = simple_anneal( energy, X0, Trange, iter )

N = length(energy);

xi = X0;
ti = Trange(2);
dt = (Trange(2)-Trange(1))/iter;
if rand>0.5, ii=1; else ii=-1; end

sa=zeros(iter,1);
acc=zeros(iter,1);
t=zeros(iter,1);

thres=0.02;

for i = 1 : iter
   t(i) = ti;
   yi = energy(xi);
   
   xii=xi+ii;
   if xii==0
       xii=2;
       ii=1;
   end
   if xii==N+1
       xii=N-2; 
       ii=-1;
   end
    
   yii = energy(xii);
   accept = exp( (yii-yi) / ti )-1;
   
   acc(i) = accept;
   
   if accept < thres
       %sa(i) = energy(xii);
       xi   = xii;
   else
       %sa(i) = energy(xi);
       ii=-ii;
   end
   
   sa(i) = xi;
   
   ti = ti - dt;
    
end



end

