function [ ax ] = shifting_extrema( varargin )

[ax,args,nargs] = axescheck(varargin{:});

p=0.001; fn=[]; plottemp=[];
if nargs == 4; [x, extrema, dy, sa] = deal(args{:}); end
if nargs == 5; [x, extrema, dy, sa, p] = deal(args{:}); end
if nargs == 6, [x, extrema, dy, sa, p,fn] = deal(args{:}); end
if nargs == 7, [x, extrema, dy, sa, p,fn,plottemp] = deal(args{:}); end

xe=x(extrema);

tofile = ~isempty(fn);
showtime = ~isempty(plottemp);

[N_iter,N_pts] = size(sa);
if tofile
   if N_iter>fn.frames;
      step = round(N_iter / fn.frames);
   end
end

if showtime
   h_txt=text(plottemp.pos(1),plottemp.pos(2),sprintf('T=%1.3f',plottemp.t(1)));
   set(h_txt,'FontSize',plottemp.size);
   set(h_txt,'Color',plottemp.color);
end

[minx,maxx] = minmax(x);
maxyabs = 0;

for t = 1 : N_iter
    yy = spline(xe, dy(t,:), x);
    maxyabs = max(maxyabs,max(abs(yy(:))));
end

ax = newplot(ax);
if ~ishold(ax)
    axis(ax,[minx maxx -maxyabs maxyabs])
end
co = get(ax,'colororder');

if size(co,1)>=3
    colors = [ co(1,:);co(2,:);co(3,:)];
    lstyle = '-';
else
    colors = repmat(co(1,:),3,1);
    lstyle = '-';
end

yy = spline(xe, dy(1,:), x);

body = matlab.graphics.animation.AnimatedLine('color',colors(2,:),...
                                                'linestyle',lstyle,...
                                                'Parent',ax,...
                                                'MaximumNumPoints',N_iter,...
                                                'tag','body');
for i = 1:N_pts
    head(i) = line('parent',ax,'color',colors(1,:),'marker','o','MarkerSize',10, ...
                    'MarkerFaceColor', colors(1,:), 'linestyle','none', ...
                    'xdata',x(1,i),'ydata',yy(1),'Tag',sprintf('head%d',i));
end

if ( length(x) < 2000 )
    updateFcn = @()drawnow;
else
    updateFcn = @()drawnow('update');
end

fnitr=1;
fileitr=1;

for t = 1 : N_iter
    pause(p);
    % Line
    yy = spline(xe, dy(t,:), x);
    clearpoints(body);
    addpoints(body,x,yy);
    
    if showtime
        set(h_txt,'String',sprintf('T=%1.3f',plottemp.t(t))); 
    end
    
    % Points
    for a = 1 : N_pts
        idx=sa(t,a);
        set(head(a),'xdata',x(idx),'ydata',yy(idx));
    end
    updateFcn();
    
    if tofile && fnitr==step
        export_fig(gcf, sprintf('%s.%05d.png',fn.filename,fileitr), '-q100');
        fileitr = fileitr + 1;
        fnitr=1;
    else
        fnitr=fnitr+1;
    end
end

function [minx,maxx] = minmax(x)
    minx = min(x(isfinite(x)));
    maxx = max(x(isfinite(x)));
    if minx == maxx
        minx = maxx-1;
        maxx = maxx+1;
    end
end

end

