function [ sa, acc ] = shifting_anneal( x, extrema, dy, X0, T, v )

N=length(x);
xe = x(extrema);
iter = size(dy,1);
xi = X0;
if rand>0.5, ii=1; else ii=-1; end

sa=zeros(iter,1);
acc=zeros(iter,1);

thres=0.02;

for i = 1 : iter
   yy = spline(xe, dy(i,:), x);
    
   ti = T(i);
   yi = yy(xi);
   
   xii=xi+ii;
   if xii==0
       xii=2;
       ii=1;
   end
   if xii==N+1
       xii=N-2; 
       ii=-1;
   end
    
   yii = yy(xii);
   accept = exp( (yii-yi) / ti )-1;
   
   acc(i) = accept;
   
   if accept < thres
       if v >= rand         % Velocity
          xi   = xii;
       end
   else
       ii=-ii;
   end
   
   sa(i) = xi;
    
end

end

