function [ ax, dy ] = flip_extrema( varargin )

[ax,args,nargs] = axescheck(varargin{:});

p=0.001;
if nargs == 4; [x, y, xx, T] = deal(args{:}); end
if nargs == 5; [x, y, xx, T, p] = deal(args{:}); end

yy = spline(x, y, xx);
[minx,maxx] = minmax(xx);
[miny,maxy] = minmax(yy);
maxyabs = max(abs(miny),abs(maxy));

% Determine random endpoints for spline nodes
dy = zeros(T,length(x));
for i = 1 : length(x)
    ynew = (2 * rand * maxyabs)-maxyabs;
    dy(:,i) = linterp([1 T],[y(i) ynew],1:T);
end

for t = 1 : T
    yy = spline(x, dy(t,:), xx);
    maxyabs=max(maxyabs,abs(max(yy(:))));
end

ax = newplot(ax);
if ~ishold(ax)
    axis(ax,[minx maxx -maxyabs maxyabs])
end
co = get(ax,'colororder');
m = length(xx);

if size(co,1)>=3
    colors = [ co(1,:);co(2,:);co(3,:)];
    lstyle = '-';
else
    colors = repmat(co(1,:),3,1);
    lstyle = '--';
end

body = matlab.graphics.animation.AnimatedLine('color',colors(2,:),...
                                            'linestyle',lstyle,...
                                            'Parent',ax,...
                                            'MaximumNumPoints',m,...
                                            'tag','body');
                                        
if ( length(x) < 2000 )
    updateFcn = @()drawnow;
else
    updateFcn = @()drawnow('update');
end

for t = 1 : T
    pause(p);
    yy = spline(x, dy(t,:), xx);
    clearpoints(body);
    addpoints(body,xx,yy);
    updateFcn();
    
end


function [minx,maxx] = minmax(x)
    minx = min(x(isfinite(x)));
    maxx = max(x(isfinite(x)));
    if minx == maxx
        minx = maxx-1;
        maxx = maxx+1;
    end
end

end

