%% Init

x=1:.01:30;
y=sin(x);
z=normpdf(linspace(-3,3,length(x)));
figure; plot(x,z.*y);
hold on;

%% Point following curve

cometd(x,z.*y,0.1,0.001);

%% Get simulated annealing points

X0 = round(rand*length(x));
T0 = 1;
energy = z.*y;
iter = 10000;

[sa,acc,t] = simple_anneal( energy, X0, [.01 .5], iter);
yy = energy(sa);
xx = x(sa);

figure; ax=plot(x,energy);
hold on;
plottemp.pos=[25,0.3];
plottemp.t=t;
plottemp.size=12;
plottemp.color=[0 0 1];
comet_anneal(xx',yy',0.1,0.001,[],plottemp);

figure,plot(1:iter,acc);

%% Output to png's

fileout.filename = '/Users/areid/Documents/MATLAB/anneal/comet/sim1';
fileout.frames = 500;
plottemp.pos=[25,0.3];
plottemp.t=t;
plottemp.size=12;
plottemp.color=[0 0 1];

figure; plot(x,energy);
hold on;

comet_anneal(xx,yy,0.1,0.001,fileout,plottemp);

%% Get multiple simulated annealing points

sim_name = 'High starting T';
sim_fn   = 'hight';
T0 = .4;
energy = z.*y;
iter = 10000;

N_pts = 10;
xx = zeros(iter, N_pts);
yy = zeros(iter, N_pts);

for i = 1 : N_pts
    X0 = round(rand*length(x));
    [sa,acc,t] = simple_anneal( energy, X0, [.01 T0], iter);
    yy(:,i) = energy(sa);
    xx(:,i) = x(sa);
end

h=figure; ax=plot(x,energy);
set(h,'Color','w');
resize_window(h,[800 500],[200 200]);
hh=title(sim_name);
set(hh,'FontSize',25');
set(hh,'FontWeight','bold');
set(gca,'colororder',[1 0 0]);
set(gca,'YTickLabel',[]);
set(gca,'XTickLabel',[]);
hh = xlabel('Free Parameter');
set(hh, 'FontSize', 18);
hh = get(gca,'XLabel');
set(hh,'Position',get(hh,'Position') - [0 .03 0]);
hh = ylabel('Objective Function');
set(hh, 'FontSize', 18);
hh = get(gca,'YLabel');
set(hh,'Position',get(hh,'Position') - [.8 0 0]);
hold on;
plottemp.pos=[25,0.3];
plottemp.t=t;
plottemp.size=15;
plottemp.color=[0 0 1];
comet_anneal(xx,yy,0.1,0.001,[],plottemp);

%figure,plot(1:iter,acc);

%% Output to png's

outdir = sprintf('/Users/areid/Documents/MATLAB/anneal/%s',sim_fn);
if exist(outdir,'dir')
   rmdir(outdir,'s'); 
end
mkdir(outdir);

fileout.filename = sprintf('%s/vid',outdir);
fileout.frames = 500;

h=figure; ax=plot(x,energy);
set(h,'Color','w');
resize_window(h,[800 500],[200 200]);
hh=title(sim_name);
set(hh,'FontSize',25');
set(hh,'FontWeight','bold');
set(gca,'colororder',[1 0 0]);
set(gca,'YTickLabel',[]);
set(gca,'XTickLabel',[]);
hh = xlabel('Free Parameter');
set(hh, 'FontSize', 18);
hh = get(gca,'XLabel');
set(hh,'Position',get(hh,'Position') - [0 .03 0]);
hh = ylabel('Objective Function');
set(hh, 'FontSize', 18);
hh = get(gca,'YLabel');
set(hh,'Position',get(hh,'Position') - [.8 0 0]);
hold on;
plottemp.pos=[25,0.3];
plottemp.t=t;
plottemp.size=15;
plottemp.color=[0 0 1];
comet_anneal(xx,yy,0.1,0.001,fileout,plottemp);

%% Model as spline

mins=[1]; maxes=[1]; extrema=[1];
delta_last=energy(2)-energy(1);
for j = 3 : length(x)
    i = j - 1;
    delta = energy(j)-energy(i);
    if delta > 0 && delta_last < 0
       mins = [mins i];
       extrema = [extrema i];
    elseif delta < 0 && delta_last > 0
       maxes = [maxes i];
       extrema = [extrema i];
    end
    delta_last = delta;
end

extrema=[extrema length(x)];

figure,plot(x,energy);
hold on;
plot(x(extrema),energy(extrema));

ys = spline(x(extrema),energy(extrema),x);

figure,plot(x,ys);

%% Video flip

figure, flip_extrema(x(extrema), energy(extrema), x , 1000, 0.001);


%% Randomly shifting objective


iter = 10000;
evolve=round(iter/2);
y = energy(extrema);
dy = zeros(iter,length(extrema));
maxyabs = max(abs(y(:)));

for i = 1 : length(extrema)
    if i<3 || i > length(extrema)-2
        ynew = y(i);        % Keep endpoints stable
    else
        ynew = rand * maxyabs;
    end
    if y(i) > 0; ynew = -ynew; end
    dd = linterp([1 evolve],[y(i) ynew],1:evolve);
    dy(:,i) = [dd';ones(iter-evolve,1).*dd(end)];
end

%% Annealing with constant T and changing objective fcn

sim_name = 'Shifting Objective - Low T';
sim_fn   = 'shift-001';
T0 = .01;
Tend = 0.001;
T = ones(iter,1) * T0;
T(evolve+1:end)=linterp([1 evolve],[T0 Tend],1:evolve)';

N_pts = 15;
N_ext = length(extrema);
sa = zeros(iter, N_pts);

[~,idxmin] = min(energy);

for i = 1 : N_pts
    X0 = idxmin + round((rand-.5)*100);
    Ti = T*(1+(rand-.5));        % Randomly vary temperature
    [ sa_i, acc ] = shifting_anneal( x, extrema, dy, X0, Ti, (rand+.3)/1.3 );
    sa(:,i) = sa_i;
end

%% Video

outdir = sprintf('/Users/areid/Documents/MATLAB/anneal/%s',sim_fn);
if exist(outdir,'dir')
   rmdir(outdir,'s'); 
end
mkdir(outdir);

fileout.filename = sprintf('%s/vid',outdir);
fileout.frames = 500;

plottemp.pos=[25,0.3];
plottemp.t=T;
plottemp.size=15;
plottemp.color=[0 0 1];

h=figure; ax=plot(x,ys);
set(ax,'Color',[0.6 0.6 1]);
set(h,'Color','w');
resize_window(h,[800 500],[200 200]);
hh=title(sim_name);
set(hh,'FontSize',25');
set(hh,'FontWeight','bold');
set(gca,'colororder',[1 0 0]);
set(gca,'YTickLabel',[]);
set(gca,'XTickLabel',[]);
hh = xlabel('Free Parameter');
set(hh, 'FontSize', 18);
hh = get(gca,'XLabel');
set(hh,'Position',get(hh,'Position') - [0 .03 0]);
hh = ylabel('Objective Function');
set(hh, 'FontSize', 18);
hh = get(gca,'YLabel');
set(hh,'Position',get(hh,'Position') - [.8 0 0]);
hold on;
shifting_extrema( x, extrema, dy, sa, 0, fileout, plottemp );
