function h = plot_g1d( x, peaks, fwhm, size )

    xp = x(peaks);

    % Get the Gaussian kernel
    dx = x(2)-x(1);
    s = fwhm / (2 * sqrt(2*log(2)));
    gauss = normpdf(-fwhm*3:dx:fwhm*3,0,s);

    % No Gaussian
    h = figure;
    h.Color = 'w';
    
    hh = plot(x,zeros(length(x),1));
    hh.LineWidth = 2;
    hh.Color = 'b';
    
    hold on;
    
    for i = 1 : length(peaks)
       hh = plot([xp(i) xp(i)],[0 1]); 
       hh.LineWidth = 2;
       hh.Color = 'b';
    end
    
    ylim([-1 3]);
    
    ax = gca;
    ax.Visible = 'off';
    
    resize_window(h, size, [300 300]);

    
    % Wel Gaussian
    h = figure;
    h.Color = 'w';
    
    hh = plot(x,zeros(length(x),1));
    hh.LineWidth = 2;
    hh.Color = 'b';
    
    hold on;
    
    for i = 1 : length(peaks)
       hh = plot([xp(i) xp(i)],[0 1]); 
       hh.LineWidth = 2;
       hh.Color = 'b';
    end
    
    % Get Gaussian union
    y = zeros(length(x),1);
    y(peaks) = 1;
    yg = conv(y,gauss,'same');
    yg = 2 * yg / max(yg);
    hh = plot(x,yg);
    hh.LineWidth = 2;
    hh.Color = 'r';
    
    ylim([-1 3]);
    
    ax = gca;
    ax.Visible = 'off';
    
    resize_window(h, size, [300 300]);

end

