function mat = gauss2d(mat, width, sigma, center)

gsize = size(mat);
sigma = sigma * gsize(1) / width;
[R,C] = ndgrid(1:gsize(1), 1:gsize(2));
mat = gaussC(R, C, sigma, center); % round([gsize(1)/2 gsize(2)/2]));

end

function val = gaussC(x, y, sigma, center)

xc = center(1);
yc = center(2);
exponent = ((x-xc).^2 + (y-yc).^2)./(2*sigma);
val       = (exp(-exponent));    

end